% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_scoreboard.R
\name{nba_scoreboard}
\alias{nba_scoreboard}
\title{\strong{Get NBA Stats API Scoreboard}}
\usage{
nba_scoreboard(league_id = "00", game_date = "2021-07-20", day_offset = 0, ...)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{game_date}{Game Date}

\item{day_offset}{Day Offset (integer 0,-1)}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: Available, EastConfStandingsByDay,
GameHeader, LastMeeting, LineScore, SeriesStandings, WestConfStandingsByDay

\strong{GameHeader}\tabular{ll}{
   col_name \tab types \cr
   GAME_DATE_EST \tab character \cr
   GAME_SEQUENCE \tab character \cr
   GAME_ID \tab character \cr
   GAME_STATUS_ID \tab character \cr
   GAME_STATUS_TEXT \tab character \cr
   GAMECODE \tab character \cr
   HOME_TEAM_ID \tab character \cr
   VISITOR_TEAM_ID \tab character \cr
   SEASON \tab character \cr
   LIVE_PERIOD \tab character \cr
   LIVE_PC_TIME \tab character \cr
   NATL_TV_BROADCASTER_ABBREVIATION \tab character \cr
   LIVE_PERIOD_TIME_BCAST \tab character \cr
   WH_STATUS \tab character \cr
}


\strong{LineScore}\tabular{ll}{
   col_name \tab types \cr
   GAME_DATE_EST \tab character \cr
   GAME_SEQUENCE \tab character \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY_NAME \tab character \cr
   TEAM_WINS_LOSSES \tab character \cr
   PTS_QTR1 \tab character \cr
   PTS_QTR2 \tab character \cr
   PTS_QTR3 \tab character \cr
   PTS_QTR4 \tab character \cr
   PTS_OT1 \tab character \cr
   PTS_OT2 \tab character \cr
   PTS_OT3 \tab character \cr
   PTS_OT4 \tab character \cr
   PTS_OT5 \tab character \cr
   PTS_OT6 \tab character \cr
   PTS_OT7 \tab character \cr
   PTS_OT8 \tab character \cr
   PTS_OT9 \tab character \cr
   PTS_OT10 \tab character \cr
   PTS \tab character \cr
   FG_PCT \tab character \cr
   FT_PCT \tab character \cr
   FG3_PCT \tab character \cr
   AST \tab character \cr
   REB \tab character \cr
   TOV \tab character \cr
}


\strong{SeriesStandings}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   HOME_TEAM_ID \tab character \cr
   VISITOR_TEAM_ID \tab character \cr
   GAME_DATE_EST \tab character \cr
   HOME_TEAM_WINS \tab character \cr
   HOME_TEAM_LOSSES \tab character \cr
   SERIES_LEADER \tab character \cr
}


\strong{LastMeeting}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   LAST_GAME_ID \tab character \cr
   LAST_GAME_DATE_EST \tab character \cr
   LAST_GAME_HOME_TEAM_ID \tab character \cr
   LAST_GAME_HOME_TEAM_CITY \tab character \cr
   LAST_GAME_HOME_TEAM_NAME \tab character \cr
   LAST_GAME_HOME_TEAM_ABBREVIATION \tab character \cr
   LAST_GAME_HOME_TEAM_POINTS \tab character \cr
   LAST_GAME_VISITOR_TEAM_ID \tab character \cr
   LAST_GAME_VISITOR_TEAM_CITY \tab character \cr
   LAST_GAME_VISITOR_TEAM_NAME \tab character \cr
   LAST_GAME_VISITOR_TEAM_CITY1 \tab character \cr
   LAST_GAME_VISITOR_TEAM_POINTS \tab character \cr
}


\strong{EastConfStandingsByDay}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   SEASON_ID \tab character \cr
   STANDINGSDATE \tab character \cr
   CONFERENCE \tab character \cr
   TEAM \tab character \cr
   G \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   HOME_RECORD \tab character \cr
   ROAD_RECORD \tab character \cr
}


\strong{WestConfStandingsByDay}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   SEASON_ID \tab character \cr
   STANDINGSDATE \tab character \cr
   CONFERENCE \tab character \cr
   TEAM \tab character \cr
   G \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   HOME_RECORD \tab character \cr
   ROAD_RECORD \tab character \cr
}


\strong{Available}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   PT_AVAILABLE \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Scoreboard}

\strong{Get NBA Stats API Scoreboard}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_scoreboard(league_id = '00', game_date = '2021-07-20')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Schedule Functions: 
\code{\link{nba_schedule}()},
\code{\link{nba_scoreboardv2}()},
\code{\link{nba_scoreboardv3}()},
\code{\link{nba_todays_scoreboard}()}
}
\author{
Saiem Gilani
}
\concept{NBA Schedule Functions}
