% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-dry-run.R
\name{req_dry_run}
\alias{req_dry_run}
\title{Perform a dry run}
\usage{
req_dry_run(
  req,
  quiet = FALSE,
  redact_headers = TRUE,
  testing_headers = is_testing(),
  pretty_json = getOption("httr2_pretty_json", TRUE)
)
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{quiet}{If \code{TRUE} doesn't print anything.}

\item{redact_headers}{Redact confidential data in the headers? Currently
redacts the contents of the Authorization header to prevent you from
accidentally leaking credentials when debugging/reprexing.}

\item{testing_headers}{If \code{TRUE}, removes headers that httr2 would otherwise
be automatically added, which are likely to change across test runs. This
currently includes:
\itemize{
\item The default \code{User-Agent}, which varies based on libcurl, curl, and
httr2 versions.
\item The `Host`` header, which is often set to a testing server.
\item The \code{Content-Length} header, which will often vary by platform because
of varying newline encodings. (And is also not correct if you have
\code{pretty_json = TRUE}.)
\item The \code{Accept-Encoding} header, which varies based on how libcurl was
built.
}}

\item{pretty_json}{If \code{TRUE}, automatically prettify JSON bodies.}
}
\value{
Invisibly, a list containing information about the request,
including \code{method}, \code{path}, and \code{headers}.
}
\description{
This shows you exactly what httr2 will send to the server, without
actually sending anything. It requires the httpuv package because it
works by sending the real HTTP request to a local webserver, thanks to
the magic of \code{\link[curl:curl_echo]{curl::curl_echo()}}.
}
\details{
\subsection{Limitations}{
\itemize{
\item The HTTP version is always \code{HTTP/1.1} (since you can't determine what it
will actually be without connecting to the real server).
}
}
}
\examples{
# httr2 adds default User-Agent, Accept, and Accept-Encoding headers
request("http://example.com") |> req_dry_run()

# the Authorization header is automatically redacted to avoid leaking
# credentials on the console
req <- request("http://example.com") |> req_auth_basic("user", "password")
req |> req_dry_run()

# if you need to see it, use redact_headers = FALSE
req |> req_dry_run(redact_headers = FALSE)
}
