% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_nb.R
\name{zero_nb}
\alias{zero_nb}
\title{Zero-Inflated Negative Binomial Regression Model}
\usage{
zero_nb(y, x, size, a = 1, b = 1, mu.start = 1, beta.prior.mean = 0,
  beta.prior.sd = 1, iters = 1000, burn = 500, nthin = 1, plots = T,
  progress.bar = T)
}
\arguments{
\item{y}{numeric response vector.}

\item{x}{numeric predictor matrix.}

\item{size}{size parameter for negative binomial likelihood distributions.}

\item{a}{shape parameter for gamma prior distributions.}

\item{b}{rate parameter for gamma prior distributions.}

\item{mu.start}{initial value for mu parameter.}

\item{beta.prior.mean}{mu parameter for normal prior distributions.}

\item{beta.prior.sd}{standard deviation for normal prior distributions.}

\item{iters}{number of iterations for the Markov chain to run.}

\item{burn}{numeric burn-in length.}

\item{nthin}{numeric thinning rate.}

\item{plots}{logical operator. \code{TRUE} to output plots.}

\item{progress.bar}{logical operator. \code{TRUE} to print progress bar.}
}
\value{
\code{zero_nb} returns a list which includes the items
\describe{
   \item{mu}{numeric vector; posterior distribution of mu parameter}
   \item{beta}{numeric matrix; posterior distributions of regression coefficients}
   \item{p}{numeric vector; posterior distribution of parameter 'p', the 
   probability of a given zero observation belonging to the model's zero component}
   \item{ll}{numeric vector; posterior log-likelihood}    
}
}
\description{
\code{zero_nb} is used to fit zero-inflated 
negative binomial regression models to count data via Bayesian inference.
}
\details{
Fits a zero-inflated negative binomial (ZINB) model.
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
