% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sf.tiles_rhine}
\alias{sf.tiles_rhine}
\title{Tiling along the active floodplain of the River Rhine}
\format{
A \code{sf} containing 40 polygons with 18 attributes:
\describe{
\item{id}{of the tile (type \code{integer}).}
\item{name}{of the tile (type \code{character}).}
\item{river}{of the tile (type \code{character}) in this case RHINE'.}
\item{name_km}{of the tile (type \code{character}).}
\item{from_km}{river kilometer of the tiles upper limit (type \code{numeric}).}
\item{to_km}{river kilometer of the tiles lower limit (type \code{numeric}).}
\item{gs_upper}{name of the tiles upper gauging station (type \code{character}).}
\item{gs_lower}{name of the tiles lower gauging station (type \code{character}).}
\item{geometry}{\code{sfc_POLYGON} column storing the geometries.}
\item{xmin}{of the tile extent (type \code{integer}). Minimum of UTM Easting (m).}
\item{xmax}{of the tile extent (type \code{integer}). Maximum of UTM Easting (m).}
\item{ymin}{of the tile extent (type \code{integer}). Minimum of UTM Northing (m).}
\item{ymax}{of the tile extent (type \code{integer}). Maximum of UTM Northing (m).}
\item{lon_min}{of the tile extent (type \code{numeric}). Minimum of Longitude (decimal °).}
\item{lon_max}{of the tile extent (type \code{numeric}). Maximum of Longitude (decimal °).}
\item{lat_min}{of the tile extent (type \code{numeric}). Minimum of Latitude (decimal °).}
\item{lat_max}{of the tile extent (type \code{numeric}). Maximum of Latitude (decimal °).}
\item{url}{of the tile (type \code{character}).}
}
}
\usage{
sf.tiles_rhine
}
\description{
This dataset contains 40 rectangular polygons / tiles along the
active floodplain along the German, freeflowing parts of the River Rhine
from the weir Iffezheim to the Dutch border near Kleve in the coordinate
reference system
\href{https://spatialreference.org/ref/epsg/25832/}{ETRS 1989 UTM 32N}.

The tiles represent the original tiling of the internally used digital
elevation model (Weber 2020).
}
\references{
\insertRef{weber_dgms_2020}{hydflood}

\insertRef{weber_dgm_rhine_2020}{hydflood}
}
\seealso{
\code{\link{sf.tiles_elbe}}, \code{\link{sf.tiles_rhine}}
}
\keyword{datasets}
