\name{plot_param}

\alias{plot_param}

\title{
Plotting parameter with boxplots and dotty plots
}

\description{
The function \code{plot_param} generates plots to visualize parameter 
sensitivity and distribution in the context of multi-objective optimization 
using hydrological models. It helps in understanding how different parameters 
affect the model's performance and the trade-offs involved. \cr

\bold{(*)}: When \code{do.png == TRUE}, graphics are written to disk. \cr
}

\usage{
plot_param(Results,
           legend.param = NULL,
           col = NULL,
           col.param = NULL,
           col.lines = NULL,
           name.param = NULL,
           lwd = 2,
           main = "study case #1",
           drty.out = "MOPSO.out",
           cex.pt = 1,
           cex.main = 1,
           cex.lab = 1,
           cex.axis = 1,
           cex.leg = 1,
           do.png = FALSE)
}
            
\arguments{
  \item{Results}{(\code{list}) \cr
    Object containing preprocessed hydrological results.
  }
  \item{legend.param}{(\code{character} or \code{NULL}) \cr
    Legend text for the parameters in the plots.
  }
  \item{col}{(\code{character} or \code{NULL}) \cr
    Colors used for points in the parameter dotty plots.
  }
  \item{col.param}{(\code{character} or \code{NULL}) \cr
    Specific colors for lines or points representing parameters in the 
    parameter boxplots.
  }
  \item{col.lines}{(\code{character} or \code{NULL}) \cr
    Specific colors for lines in the parameter boxplots.
  }
  \item{name.param}{(\code{character} or \code{NULL}) \cr
    Custom names for the parameters to be plotted.
  }
  \item{lwd}{(\code{numeric}) \cr
    Line width for plotting parameters in boxplots.
  }
  \item{main}{(\code{character}) \cr
    Main title for the plot.
  }
  \item{drty.out}{(\code{character}) \cr
    Output directory where plots will be saved if specified to save as PNG files.
  }
  \item{cex.pt}{(\code{numeric}) \cr
    Size of points in the plots.
  }
  \item{cex.main}{(\code{numeric}) \cr
    Size of the main title text in the plot.
  }
  \item{cex.lab}{(\code{numeric}) \cr
    Size of the axis label text in the plots.
  }
  \item{cex.axis}{(\code{numeric}) \cr
    Size of the axis values text in the plots.
  }
  \item{cex.leg}{(\code{numeric}) \cr
    Size of the legend text in the plots.
  }
  \item{do.png}{(\code{logical}) \cr
    Boolean value indicating whether the plots should be saved as PNG files.
  }
}

\value{
No return value; generates plots as a side effect.
}

\author{
Rodrigo Marinao Rivas \email{ra.marinao.rivas@gmail.com}, 
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}

\seealso{
\code{\link{plot_out}}, \code{\link{plot_pof}}
}

\keyword{parameter sensitivity}
\keyword{hydrological model}
\keyword{multi-objective optimisation}
