% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_precip_hydroMet.R
\name{precip_hydroMet}
\alias{precip_hydroMet}
\alias{precip_hydroMet,hydroMet_compact-method}
\title{Make homogeneity test or fill gaps in a series}
\usage{
precip_hydroMet(
  obj,
  col_target = 2,
  fill = FALSE,
  method = "spearman",
  min_value = 0.2
)

\S4method{precip_hydroMet}{hydroMet_compact}(
  obj,
  col_target = 2,
  fill = FALSE,
  method = "spearman",
  min_value = 0.2
)
}
\arguments{
\item{obj}{an \code{hydroMet_compact} class object.}

\item{col_target}{numeric. The column number of the target series (either to test homogeneity or to fill gaps) in \code{compact} slot.}

\item{fill}{logical. By default value (\code{FALSE}) you will make an homogeneity test to your target series.}

\item{method}{string (default is \code{spearman} - possible values are: \code{spearman}, \code{pearson} or \code{kendall}). When creating the regional (or master series) the method uses a weighted mean. The weighted values are the correlations coefficients.}

\item{min_value}{numeric. Series with a correlation value less than \code{min_value} are thrown away.}
}
\value{
If \code{fill = FALSE} the method will return a list with three elements: a data frame with all necessary values to correct your target serie, a plot with \code{p-values} and the correlation matrix. When \code{fill = TRUE} the list will contain: the data frame with the target series gaps filled and the correlation matrix.
}
\description{
This method can do both: test homogeneity in precipitation series or fill data gaps using regional analysis.
}
\section{Functions}{
\itemize{
\item \code{precip_hydroMet,hydroMet_compact-method}: homogeneity test applied to precipitation data stored in \code{compact} class.
}}

\examples{
# Load daily precipitation data-set from BDHI
load( paste0(system.file('extdata', package = "hydroToolkit"), '/bdhi_p.rda') )

# Fill gaps in Tupungato station
relleno <- precip_hydroMet(obj = bdhi_p, col_target = 5, fill = TRUE)

}
