% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{mafr}
\alias{mafr}
\title{MAFR - Maximum Flow Fluctuation Rate (Metric 2)}
\usage{
mafr(x)
}
\arguments{
\item{x}{Data frame (time series) from an event with equal flow trend. The
data frame must contain a date-time column (\code{Time}) and a flow rate
column (\code{Q}) and must be in a compatible format
(see \code{\link[=flow]{flow()}}).}
}
\value{
Returns a numeric value which is the maximum (absolute) flow
    fluctuation rate. If a data frame containing \code{NA} flow rates (\code{Q})
    is given, \code{NA} is returned.
}
\description{
The maximum flow fluctuation rate (MAFR, unit: \eqn{m^3/s})
    represents the highest absolute flow change of two consecutive time steps
    within an event. Given an event with equal flow trend, the maximum flow
    fluctuation rate is computed and returned.
}
\examples{
data(Q)
Q <- flow(Q[3:4, ])
mafr(Q)
}
