% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getAccessions}
\alias{getAccessions}
\title{Getting Accession Data from ICARDA's Genebank Documentation System}
\usage{
getAccessions(
  crop = "",
  ori = NULL,
  IG = "",
  doi = FALSE,
  taxon = FALSE,
  collectionYear = FALSE,
  coor = FALSE,
  available = FALSE
)
}
\arguments{
\item{crop}{character. Crop for which to get accession data. See section 'Details' for available crops or use \code{\link[icardaFIGSr]{getCrops}} function. Default: "".}

\item{ori}{string. Country of origin using the ISO 3166-1 alpha-3 country codes. Default: NULL.}

\item{IG}{integer. Unique identifier of accession. Default: "".}

\item{doi}{boolean. If \code{TRUE} , the function will return the digital object identifiers DOI for the accessions. Default: FALSE.}

\item{taxon}{boolean. If \code{TRUE}, the function will return the taxon information of the accessions. Default: FALSE.}

\item{collectionYear}{boolean. If \code{TRUE}, the function will return the year of the collecting mission. Default: FALSE.}

\item{coor}{boolean. If \code{TRUE}, returns only georeferenced accessions containing longitude and latitude. Default: FALSE.}

\item{available}{boolean. If \code{TRUE}, returns the availability of accessions for distribution, Default: FALSE.}
}
\value{
A data frame with accession passport data for specified crop in \code{crop} from the locations in \code{ori}.
}
\description{
Return a data frame with accession data for the specified crop.
}
\details{
Types of crops available include:
\itemize{
  \item{'Aegilops'}
  \item{'Barley'}
  \item{'Bread wheat'}
  \item{'Chickpea'}
  \item{'Durum wheat'}
  \item{'Faba bean'}
  \item{'Faba bean BPL'}
  \item{'Forage and range'}
  \item{'Lathyrus'}
  \item{'Lentil'}
  \item{'Medicago annual'}
  \item{'Not mandate cereals'}
  \item{'Pisum'}
  \item{'Primitive wheat'}
  \item{'Trifolium'}
  \item{'Vicia'}
  \item{'Wheat hybrids'}
  \item{'Wheat wild relatives'}
  \item{'Wild Cicer'}
  \item{'Wild Hordeum'}
  \item{'Wild Lens'}
  \item{'Wild Triticum'}
 }

 Alternatively, the list of available crops can be fetched from ICARDA's online server using \code{\link[icardaFIGSr]{getCrops}}.
}
\examples{
if(interactive()){
 # Obtain accession data for durum wheat
 durum <- getAccessions(crop = 'Durum wheat', coor = TRUE)
}
}
\author{
Khadija Aouzal, Amal Ibnelhobyb, Zakaria Kehel, Fawzy Nawar
}
