% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netwrite_ego.R
\name{ego_netwrite}
\alias{ego_netwrite}
\title{Ego Network Cleaning and Measure Calculation (\code{ego_netwrite})}
\usage{
ego_netwrite(
  egos,
  ego_id,
  alters = NULL,
  alter_id = NULL,
  alter_ego = NULL,
  alter_types = NULL,
  max_alters = Inf,
  alter_alter = NULL,
  aa_ego = NULL,
  i_elements = NULL,
  j_elements = NULL,
  directed = FALSE,
  aa_type = NULL,
  missing_code = 99999,
  na.rm = FALSE,
  egor = FALSE,
  egor_design = NULL
)
}
\arguments{
\item{egos}{A data frame containing measures of ego attributes.}

\item{ego_id}{A vector of unique identifiers corresponding to each ego, or a single character value indicating the name of the column in \code{egos} containing ego identifiers.}

\item{alters}{A data frame containing measures of alter attributes.}

\item{alter_id}{A vector of identifiers indicating which alter is associated with a given row in \code{alters}, or a single character value indicating the name of the column in \code{alters} containing alter identifiers.}

\item{alter_ego}{A vector of identifiers indicating which ego is associated with a given alter, or a single character value indicating the name of the column in \code{alters} containing ego identifiers.}

\item{alter_types}{A character vector indicating the columns in \code{alters} that indicate whether a given alter has certain types of relations with ego. These columns should all contain binary measures indicating whether alter has a particular type of relation with ego.}

\item{max_alters}{A numeric value indicating the maximum number of alters an ego in the dataset could have nominated}

\item{alter_alter}{A data frame containing an edgelist indicating ties between alters in each ego's network. This edgelist is optional, but \code{ego_netwrite} will not provide certain measures without it.}

\item{aa_ego}{A vector of identifiers indicating which ego is associated with a given tie between alters, or a single character indicating the name of the column in \code{alter_alter} containing ego identifiers.}

\item{i_elements}{A vector of identifiers indicating which alter is on one end of an alter-alter tie, or a single character indicating the name of the column in \code{alter_alter} containing these identifiers.}

\item{j_elements}{A vector of identifiers indicating which alter is on the other end of an alter-alter tie, or a single character indicating the name of the column in \code{alter_alter} containing these identifiers.}

\item{directed}{A logical value indicating whether network ties are directed or undirected.}

\item{aa_type}{A numeric or character vector indicating the types of relationships represented in the alter edgelist, or a single character value indicating the name of the column in \code{alter_alter} containing relationship type. If \code{alter_type} is specified, \code{ego_netwrite} will treat the data as a set of multi-relational networks and produce additional outputs reflecting the different types of ties occurring in each ego network.}

\item{missing_code}{A numeric value indicating "missing" values in the alter-alter edgelist.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be excluded when calculating continuous measures.}

\item{egor}{A logical value indicating whether output should include an \code{egor} object, which is often useful for visualizaton and for simulation larger networks from egocentric data.}

\item{egor_design}{If creating an \code{egor} object, a list of arguments to \code{\link[srvyr:as_survey_design]{srvyr::as_survey_design}} specifying the sampling design for egos. This argument corresponds to \code{ego_design} in \code{\link[egor:egor]{egor::egor}}.}
}
\value{
\code{ego_netwrite} returns a list containing several output objects. Users may find it easier to access and work with outputs by applying \link{list2env} to this list, which will separate outputs and store them in the R Global Environment. Note, however, that this risks overwriting existing objects in the Global Environment should those objects share names with objects in \code{netwrite}'s output. Outputs include a data frame containing measures of ego attributes, another data frame containing measures of alter attributes and network position, a third containing the alter-alter edgelist (when applicable), a fourth containing summary measures for each individual ego network, and a fifth providing summary measures for the overall dataset. Additionally, \code{ego_netwrite} returns a list of \code{igraph} objects constructed for each individual ego network, as well as an \code{egor} object for the overall dataset if desired.
}
\description{
The \code{ego_netwrite} function reads in data pertaining to ego networks and processes them into a set of standardized outputs, including measures commonly calculated for ego networks.
}
\examples{

# Simple Processing, Ignoring Ego-Alter or Alter-Alter Relation Types
ngq_nw <- ego_netwrite(egos = ngq_egos,
                       ego_id = ngq_egos$ego_id,

                       alters = ngq_alters,
                       alter_id = ngq_alters$alter_id,
                       alter_ego = ngq_alters$ego_id,

                       max_alters = 10,
                       alter_alter = ngq_aa,
                       aa_ego = ngq_aa$ego_id,
                       i_elements = ngq_aa$alter1,
                       j_elements = ngq_aa$alter2,
                       directed = FALSE)


# View summaries of individual ego networks
head(ngq_nw$summaries)

# View summary of overall dataset
head(ngq_nw$overall_summary)

# View sociogram of fourth ego network
plot(ngq_nw$igraph_objects[[4]]$igraph_ego)


# For advanced applications involving multiple relationship types
# and `egor` object creation, please consult the `ego_netwrite` vignette
vignette("ego_netwrite", package = "ideanet")
}
