% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sobelTest_unord}
\alias{sobelTest_unord}
\title{Sobel test for the indirect effect - Two ordered mediator path}
\usage{
sobelTest_unord(
  mu1,
  sig1,
  mu2,
  sig2,
  mu3,
  sig3,
  mu4,
  sig4,
  mu2b,
  sig2b,
  mu4b,
  sig4b,
  sig12 = 0L,
  sig12b = 0L,
  sig13 = 0L,
  sig14 = 0L,
  sig14b = 0L,
  sig22b = 0L,
  sig23 = 0L,
  sig24 = 0L,
  sig24b = 0L,
  sig2b3 = 0L,
  sig2b4 = 0L,
  sig2b4b = 0L,
  sig34 = 0L,
  sig34b = 0L,
  sig44b = 0L,
  indL = 1L,
  mu1_0 = 0,
  mu2_0 = 0,
  mu3_0 = 0,
  mu4_0 = 0,
  mu2b_0 = 0,
  mu4b_0 = 0
)
}
\arguments{
\item{mu1}{Value of the estimate of the independent variable on the first mediator.}

\item{sig1}{Value of the variance of the estimate of the independent variable on the first mediator.}

\item{mu2}{Value of the estimate of the first mediator on the response.}

\item{sig2}{Value of the variance of the estimate of the first mediator on the response.}

\item{mu3}{Value of the estimate of the independent variable on the second mediator.}

\item{sig3}{Value of the variance of the estimate of the independent variable on the second mediator.}

\item{mu4}{Value of the estimate of the second mediator on the response.}

\item{sig4}{Value of the variance of the estimate of the second mediator on the response.}

\item{mu2b}{Value of the estimate of the effect of the interaction of the independent and first mediator variable on the response.}

\item{sig2b}{Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the response.}

\item{mu4b}{Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response.}

\item{sig4b}{Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response.}

\item{sig12}{Value of the covariance between mu1 and mu2.}

\item{sig12b}{Value of the covariance between mu1 and mu2b.}

\item{sig13}{Value of the covariance between mu1 and mu3.}

\item{sig14}{Value of the covariance between mu1 and mu4.}

\item{sig14b}{Value of the covariance between mu1 and mu4b.}

\item{sig22b}{Value of the covariance between mu1 and mu2b.}

\item{sig23}{Value of the covariance between mu2 and mu3.}

\item{sig24}{Value of the covariance between mu2 and mu4.}

\item{sig24b}{Value of the covariance between mu2 and mu4b.}

\item{sig2b3}{Value of the covariance between mu2b and mu3.}

\item{sig2b4}{Value of the covariance between mu2b and mu4.}

\item{sig2b4b}{Value of the covariance between mu2b and mu4b.}

\item{sig34}{Value of the covariance between mu3 and mu4.}

\item{sig34b}{Value of the covariance between mu3 and mu4b.}

\item{sig44b}{Value of the covariance between mu4 and mu4b.}

\item{indL}{Value indicating the value of the independent variable used for the interaction. Typically 1.}

\item{mu1_0}{Null value for mu1.}

\item{mu2_0}{Null value for mu2.}

\item{mu3_0}{Null value for mu3.}

\item{mu4_0}{Null value for mu4.}

\item{mu2b_0}{Null value for mu2b.}

\item{mu4b_0}{Null value for mu4b.}
}
\value{
A p-value for the test for the indirect effect.
}
\description{
This function takes the parameter estimates and covariances
and performs the Sobel test for two ordered mediators.
}
\examples{
sobelTest_unord(1, .1, .25, .01, 0, 0, .15, .01, 0, 0, 0, 0)
}
