// [[Rcpp::depends(RcppArmadillo)]]

#include <RcppArmadillo.h>
#include "ieTest.h"
using namespace Rcpp;


// Function not needed by R

// Function takes the estimates, variances, and covariances
// If used for gamma and psi, includes value for G if

// Function returns the cumulative probability to be used in the 
// ps and asq-tests. 

double normU(double V1, double V1_VAR, 
             double V2 = 0, double V2_VAR = 0, int V2mult = 1, 
             double V1_V2_cov = 0, 
             double V1_0 = 0, double V2_0 = 0){
  
  double newV = V1 + V2*V2mult;
  
  arma::vec multVec = arma::ones(2);
  multVec(1) = V2mult;

  arma::mat combSig = arma::zeros(2, 2);
  combSig(0, 0) = V1_VAR;
  combSig(1, 0) = V1_V2_cov ;
  combSig(0, 1) = V1_V2_cov ;
  combSig(1, 1) = V2_VAR;

  double newVar = as_scalar(trans(multVec)*combSig*multVec);
  double z = (newV - (V1_0 + V2_0*V2mult)) / std::sqrt(newVar);
  return R::pnorm( z , 0, 1, 1, 0); // value, mean, sd, lower tail, log;
}
