% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imf_get_datastructure.R
\name{imf_get_datastructure}
\alias{imf_get_datastructure}
\title{Retrieve the datastructure definition for an IMF dataflow.}
\usage{
imf_get_datastructure(
  dataflow_id,
  progress = FALSE,
  max_tries = 10L,
  cache = TRUE,
  include_time = FALSE,
  include_measures = FALSE
)
}
\arguments{
\item{dataflow_id}{The ID of the dataflow to retrieve the datastructure for.}

\item{progress}{Logical; whether to show progress.}

\item{max_tries}{Integer; maximum retry attempts.}

\item{cache}{Logical; whether to cache the request.}

\item{include_time}{Logical; whether to include time dimensions.}

\item{include_measures}{Logical; whether to include measure dimensions.}
}
\value{
tibble::tibble(
dimension_id = character(),
type = character(),
position = integer()
)
}
\description{
Retrieve the datastructure definition for an IMF dataflow.
}
\examples{
\donttest{
if (curl::has_internet()) {
  imf_get_datastructure("PSBS")
}
}
}
