% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-registry.R
\name{register_immunarch_method}
\alias{register_immunarch_method}
\title{Register an Immunarch method (developer)}
\usage{
register_immunarch_method(
  core,
  family,
  name,
  register_family = TRUE,
  required_cols = NULL,
  need_repertoires = TRUE
)
}
\arguments{
\item{core}{A function with signature \verb{function(idata, ...)}. This is your core
implementation; it must accept an \code{ImmunData} as the first argument and \strong{must not}
declare \code{autojoin}, \code{format}, or \code{features}.}

\item{family}{String. Method family name used for dispatch (e.g., \code{"airr_stats"}).}

\item{name}{String. Method name within the family (e.g., \code{"lengths"}).}

\item{register_family}{Logical (default \code{TRUE}). If \code{TRUE}, attempts to create/ensure
the family environment by calling \code{register_airr_family()} when available.}

\item{required_cols}{Character vector of column names that \strong{must} be present in
\code{idata$annotations}. Use this to declare the minimal input schema your core needs.}

\item{need_repertoires}{Logical. Use this to declare the necessity of having aggregated
repertoires.}
}
\value{
A \strong{function} - the user-facing wrapper around \code{core}. Typical usage is to
assign it to the exported symbol of the method, e.g.:
\code{airr_stats_lengths <- register_immunarch_method(...)}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Wrap a core implementation into a user-facing function and (optionally)
register it in the in-memory method registry. The wrapper \strong{adds common
arguments} and \strong{runs safety checks} so your core stays minimal.
\subsection{What your core must look like}{
\itemize{
\item Signature: \verb{function(idata, ...)}
\item \strong{Must not} declare \code{autojoin}, \code{format}, or \code{features} - these are added by the wrapper.
}
}

\subsection{What the wrapper adds}{
\itemize{
\item Common args from \code{im_common_args()}: \code{autojoin}, \code{format}, \code{features}
(with \code{autojoin} default controlled by \code{getOption("immunarch.autojoin", FALSE)}).
\item Validates \code{idata} is an \link[immundata:ImmunData]{immundata::ImmunData} object.
\item Ensures all columns in \code{required_cols} exist in \code{idata$annotations}.
\item If \code{autojoin = TRUE} and the result is a data frame containing the repertoire id
column (\code{immundata::imd_schema("repertoire")}), joins repertoire metadata from
\code{idata$repertoires}.
}
}
}
\examples{
\dontrun{
# Minimal core implementation (must accept `idata`)
airr_stats_lengths_impl <- function(idata, seq_col = "cdr3_aa") {
  dplyr::as_tibble(idata$annotations) |>
    dplyr::distinct(.data[[immundata::imd_schema("repertoire")]], .data[[seq_col]]) |>
    dplyr::mutate(seq_len = nchar(.data[[seq_col]])) |>
    dplyr::count(.data[[immundata::imd_schema("repertoire")]], seq_len, name = "n")
}

# Register and expose a user-facing function
airr_stats_lengths <- register_immunarch_method(
  core = airr_stats_lengths_impl,
  family = "airr_stats",
  name = "lengths",
  required_cols = c("cdr3_aa", immundata::imd_schema("repertoire"))
)

# Optional: call via dispatcher
# make_airr_dispatcher("airr_stats")(idata = immdata, method = "lengths")
}

}
\keyword{internal}
