% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcChecks.R
\docType{class}
\name{mcmcChecks}
\alias{mcmcChecks}
\title{MCMC Checks}
\description{
Checks convergence, mixing, effective sample size, and divergent transitions
}
\section{Methods}{

\describe{
\item{\code{$new(fit, pars)}}{Runs diagnostics on the supplied \code{stanfit}
object, restricted to parameters identified by the character vector
\code{pars}.
\cr Tests include:
\cr Share of specified parameters with an Rhat less than 1.1. If any
have an Rhat > 1.1, \code{everything_looks_fine} is set to \code{FALSE}.
\cr Share of specified parameters with an n_eff at least 0.1\% of the
total number of posterior draws. If any have n_eff < 0.001 * N,
\code{everything_looks_fine} is set to \code{FALSE}.
\cr Share of specified parameters with an n_eff of at least 100. If any
have n_eff < 100, \code{everything_looks_fine} is set to \code{FALSE}.
\cr Number of divergent transitions during posterior sampling. If there
are any whatsoever, \code{everything_looks_fine} is set to
\code{FALSE}.
\cr Share of posterior iterations where the sampler reached the
maximum treedepth. If more than 25\\% of iterations maxed out,
\code{everything_looks_fine} is set to \code{FALSE}.}
}
}

\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{everything_looks_fine}}{logical indicating whether all MCMC tests passed.}

\item{\code{diagnostics}}{list of the outcome of each MCMC test}

\item{\code{warnings}}{list of the warning messages from failed MCMC tests}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mcmcChecks-new}{\code{mcmcChecks$new()}}
\item \href{#method-mcmcChecks-clone}{\code{mcmcChecks$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mcmcChecks-new"></a>}}
\if{latex}{\out{\hypertarget{method-mcmcChecks-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new mcmcChecks object and run diagnostics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mcmcChecks$new(fit, pars)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fit}}{A stanfit object to check}

\item{\code{pars}}{A character vector of parameter names to check}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mcmcChecks-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mcmcChecks-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mcmcChecks$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
