#ifndef HELLINGER_HPP
#define HELLINGER_HPP

#include <RcppArmadillo.h>

namespace Hellinger {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = sqrt(wt) - sqrt(adjwt);
        return 2.0 * sum(df % df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        colvec a = sqrt(adjwt);
        a = (a - sqrt(wt)) / a;
        return a * 2.0;
    }

}

#endif // HELLINGER_HPP
