#ifndef QUADRAT_HPP
#define QUADRAT_HPP

#include <RcppArmadillo.h>

namespace quadrat {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = wt - adjwt;
        return 0.5 * sum(df % df / adjwt);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        colvec a2 = adjwt % adjwt;
        a2 = (a2 - (wt % wt)) / a2;
        return a2 * 0.5;
    }

}

#endif // QUADRAT_HPP
