#ifndef RAKING_HPP
#define RAKING_HPP

#include <RcppArmadillo.h>

namespace raking {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = log(wt / adjwt);
        df = wt % df - wt + adjwt;
        return sum(df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        return ones(adjwt.size()) - wt / adjwt;
    }

}

#endif // RAKING_HPP
