#ifndef RIDGE_HPP
#define RIDGE_HPP

#include <RcppArmadillo.h>

namespace ridge {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = wt - adjwt;
        return 0.5 * sum(df % df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        return adjwt - wt;
    }

}

#endif // RIDGE_HPP
