#ifndef LASSO_HPP
#define LASSO_HPP

#include <RcppArmadillo.h>

namespace lasso {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = abs(wt - adjwt);
        return sum(df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        return sign(adjwt - wt);
    }

}

#endif // LASSO_HPP
