% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_case.R
\name{if_case}
\alias{if_case}
\title{Pipe-friendly vectorized if}
\usage{
if_case(condition, true, false, missing = NA, ...)
}
\arguments{
\item{condition}{Logical vector}

\item{true, false, missing}{Values to use for \code{TRUE}, \code{FALSE}, and \code{NA} values
of \code{condition}.
They must be either the same length as \code{condition}, or length 1.}

\item{...}{Values passed to \code{...} produce an error.
This facilitates the quiet ignoring of a piped vector.}
}
\value{
Where \code{condition} is \code{TRUE}, the matching value from \code{true};
where it's \code{FALSE}, the matching value from \code{false};
and where it's \code{NA}, the matching value from \code{missing}.
}
\description{
Compared to \code{\link[dplyr:if_else]{dplyr::if_else()}}, this function is easier to use with a pipe.
A vector piped into this function will be quietly ignored.
This allows \link[magrittr:magrittr-package]{magrittr} dots to be used in arguments
without requiring workarounds like wrapping the function in braces.
}
\details{
This function is also less strict than \code{\link[dplyr:if_else]{dplyr::if_else()}}.
If \code{true}, \code{false}, and \code{missing} are different types, they are silently
coerced to a common type.
}
\examples{
x <- c(1, 2, 5, NA)

# if_case() produces the same output as dplyr::if_else()
if_case(x > 3, "high", "low", "missing")
dplyr::if_else(x > 3, "high", "low", "missing")

# if_case() does not throw an error if arguments are not of the same type
if_case(x > 3, "high", "low", NA)
try(dplyr::if_else(x > 3, "high", "low", NA))

# if_case() can accept a piped input without an error or requiring braces
x \%>\% if_case(. > 3, "high", "low", "missing")
try(x \%>\% dplyr::if_else(. > 3, "high", "low", "missing"))
x \%>\% {dplyr::if_else(. > 3, "high", "low", "missing")}

# You can also pipe a conditional test like dplyr::if_else()
{x > 3} \%>\% if_case("high", "low", "missing")
{x > 3} \%>\% dplyr::if_else("high", "low", "missing")
}
\seealso{
\code{\link[=in_case]{in_case()}}, a pipeable alternative to \code{\link[dplyr:case_when]{dplyr::case_when()}}

\code{\link[=switch_case]{switch_case()}}, a reimplementation of \code{\link[=switch]{switch()}}

\code{\link[dplyr:if_else]{dplyr::if_else()}}, from which this function is derived
}
