% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incgraph_wrapper.R
\name{new.incgraph.network}
\alias{new.incgraph.network}
\title{IncGraph network}
\usage{
new.incgraph.network(amnt.nodes, links=NULL)

new.incgraph.network(amnt.nodes=NULL, links)

new.incgraph.network(amnt.nodes, links)
}
\arguments{
\item{amnt.nodes}{The number of nodes in the network}

\item{links}{A matrix with 2 columns and N rows, 1 row for each edge to be loaded in the network}
}
\value{
An instance of the incgraph.network class
}
\description{
\code{new.incgraph.network} creates a new IncGraph object containing either
an empty network or a network initialised from a given matrix.
}
\details{
This creates a new instance of the incgraph.network class. At least one of the parameters
(\code{amnt.nodes} or \code{links}) needs to be passed to this function.
Please note that this is a stateful object.
}
\examples{
# Create a new (empty) network with 4 nodes
net <- new.incgraph.network(amnt.nodes = 4)

# Create a new network with 4 nodes and some edges
net <- new.incgraph.network(links = matrix(c(1, 2, 2, 3, 1, 4), ncol=2))

# Create a new network with 10 nodes and some edges
net <- new.incgraph.network(amnt.nodes = 10, links = matrix(c(1, 2, 2, 3, 1, 4), ncol=2))

# Create a more complex network from a matrix
mat <- matrix(c(1, 2,
                1, 3,
                1, 4,
                1, 5,
                1, 6,
                1, 7,
                2, 7,
                2, 8,
                2, 9,
                2, 10), ncol=2)
net <- new.incgraph.network(links=mat)
# Calculate the initial orbit counts using orca
orb.counts <- calculate.orbit.counts(net)
# Modify an edge and calculate the differences in orbit counts
flip(net, 5, 10) # add (5,10)
delta1 <- calculate.delta(net, 5, 10)
# Modify another edge
flip(net, 6, 10) # add (6, 10)
delta2 <- calculate.delta(net, 6, 10)
# And another
flip(net, 1, 5)  # remove (1, 5)
delta3 <- calculate.delta(net, 1, 5)
# Verify that the new orbit counts equals the old orbit counts plus the delta counts
new.orb.counts.incremental <- orb.counts +
  delta1$add - delta1$rem +
  delta2$add - delta2$rem +
  delta3$add - delta3$rem
new.orb.counts <- calculate.orbit.counts(net)
all(new.orb.counts.incremental == new.orb.counts) # TRUE

## Additional helper functions
# Transform the network to a matrix
network.as.matrix(net)
# Get all neighbours of a node
get.neighbours(net, 1)
# Does the network contain a specific interaction?
contains(net, 5, 10)
contains(net, 7, 10)
# Reinitialise to an empty network
reset(net)
network.as.matrix(net)

}
\seealso{
\code{\link[=incgraph]{incgraph()}}, \code{\link[=calculate.orbit.counts]{calculate.orbit.counts()}}, \code{\link[=calculate.delta]{calculate.delta()}}
}
