% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regroup.R
\name{regroup}
\alias{regroup}
\alias{regroup_}
\title{Regroup 'incidence' objects}
\usage{
regroup(x, groups = NULL)

regroup_(x, groups = NULL)
}
\arguments{
\item{x}{\verb{<incidence2>} object.}

\item{groups}{\code{character} for \code{regroup()} or \link[dplyr:dplyr_tidy_select]{tidy-select} for \code{regroup_()}.

The groups to sum over.

If \code{NULL} (default) then the function returns the corresponding object with
no groupings.}
}
\description{
This function regroups an \link[=incidence]{incidence2} object across
the specified groups. The resulting \link[=incidence]{incidence2}
object will contains counts aggregated over the specified groups. The only
difference between \code{regroup()} and \code{regroup_()} is that the latter is built
on top of \link[dplyr:dplyr_tidy_select]{tidy-select} semantics for the \code{group}
input.
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist
    i <- incidence(
        dat,
        date_index = "date_of_onset",
        groups = c("gender", "hospital")
    )
    regroup(i)
    regroup_(i)
    regroup(i, "hospital")
    regroup_(i, hospital)
}
\dontshow{data.table::setDTthreads(.old)}

}
