% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_incidence}
\alias{bootstrap_incidence}
\title{Bootstrap incidence time series}
\usage{
bootstrap_incidence(x, randomise_groups = FALSE)
}
\arguments{
\item{x}{An \link[=incidence]{incidence2} object.}

\item{randomise_groups}{\code{bool}.

Should groups be randomised as well in the resampling procedure; respective
group sizes will be preserved, but this can be used to remove any
group-specific temporal dynamics.

If \code{FALSE} (default), data are resampled within groups.}
}
\value{
An \link[=incidence]{incidence2} object.
}
\description{
This function can be used to bootstrap \link[=incidence]{incidence2}
objects. Bootstrapping is done by sampling with replacement the original
input dates.
}
\details{
As original data are not stored in \link[=incidence]{incidence2}
objects, the bootstrapping is achieved by multinomial sampling of date bins
weighted by their relative incidence.
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
    data(fluH7N9_china_2013, package = "outbreaks")
    i <- incidence(
        fluH7N9_china_2013,
        date_index = "date_of_onset",
        groups = "gender"
   )
   bootstrap_incidence(i)
}
\dontshow{data.table::setDTthreads(.old)}

}
\author{
Thibaut Jombart, Tim Taylor
}
