% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_tables.R
\name{get_metadata_table_values}
\alias{get_metadata_table_values}
\title{Get all values for a specific table group}
\usage{
get_metadata_table_values(
  idTable = NULL,
  idGroup = NULL,
  det = 0,
  lang = "ES",
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{idTable}{(int): id of the table. For further information about
ids click this \href{https://es-ine.github.io/ineapir/articles/identify_codes.html}{link}.}

\item{idGroup}{(int): id of the group of variables. To get all groups
for a specific table see \code{\link[=get_metadata_table_groups]{get_metadata_table_groups()}}.}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{validate}{(logical): validate input parameters. A FALSE value means fewer API calls.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information of the values of a table group according to the table and group specified in the function
}
\description{
Get all values for a specific table group
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get the values of the group "110889" of the table with identification
# code "50902"
df <- get_metadata_table_values(idTable = 50902, idGroup = 110889, validate = FALSE)
head(df)
\dontshow{\}) # examplesIf}
}
