\name{tbeta4me}
\alias{tbeta4me}

\title{
Taxonomic Beta Biversity for MacroEcology
}
\description{
It estimates the taxonomic beta diversity of focal cells within a SpatVector 
object by considering neighboring cells located within a specified buffer.
}
\usage{
tbeta4me(PAM, SHP, width = 10000, index.family="sorensen", verbose=TRUE)
}

\arguments{
  \item{PAM}{
  A presence/absence matrix where sites are organized in rows and species in 
  columns.
}
  \item{SHP}{
  A SpatVector object representing cells distributed over a geographic space
}
  \item{width}{
  Refers to the radius of the buffer. If the SpatVector object uses a 
  latitude/longitude projection, the width is specified in meters.
}
  \item{index.family}{
  Choose either the 'sorensen' or 'jaccard' dissimilarity index.
}
  \item{verbose}{
  Logical, indicating whether messages and the progress bar are shown. The 
  default is TRUE.
}
}

\value{
The function returns a data frame that includes turnover, nestedness, total 
beta diversity, and the number of cells contributing to the mean diversity of 
the focal cell. The IDs of the cells are used as the row names of the data 
frame.
}

\references{
Yang, J., Swenson, N. G., Zhang, G., Ci, X., Cao, M., Sha, L., ... & Lin, L. 
(2015). Local-scale partitioning of functional and phylogenetic beta diversity 
in a tropical tree assemblage. Scientific Reports, 5(1), 12731.
}

\author{
Guevara, R., roger.guevara@inecol.mx
}

\examples{
%Example 1
data(PAM)
SHP <- terra::vect(paste(system.file("extdata", package = "inecolr"), 
"/test.shp", sep=""))
SHP <- SHP[1:10]
t_beta <- tbeta4me(PAM, SHP, width = 10000, index.family="sorensen")
head(t_beta)

%Example 2
data(PAM)
SHP <- terra::vect(paste(system.file("extdata", package = "inecolr"), 
"/test.shp", sep=""))
SHP <- SHP[1:10]
t_beta <- tbeta4me(PAM, SHP, width = 10000, index.family="sorensen", verbose=FALSE)
head(t_beta)
}