% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical_comparisons.R
\name{\%nand\%}
\alias{\%nand\%}
\title{NAND infix operator}
\usage{
lhs \%nand\% rhs
}
\arguments{
\item{lhs}{The left-hand side(s).}

\item{rhs}{The right-hand side value(s).}
}
\value{
An atomic value or vector the same length as the left-hand
side input.
}
\description{
This is a logical operator that implements NAND (NOT AND).
}
\details{
The NAND truth table is the inverse of the AND table:\tabular{lll}{
   LHS \tab RHS \tab Value \cr
   TRUE \tab TRUE \tab FALSE \cr
   TRUE \tab FALSE \tab TRUE \cr
   FALSE \tab TRUE \tab TRUE \cr
   FALSE \tab FALSE \tab TRUE \cr
}
}
\examples{
{
  TRUE \%nand\% TRUE # Evaluates to FALSE
  FALSE \%nand\% TRUE # Evaluates to TRUE
  FALSE \%nand\%FALSE # Evaluates to TRUE
}
}
