% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper.fm_mesh_1d}
\alias{bru_mapper.fm_mesh_1d}
\alias{ibm_n.bm_fm_mesh_1d}
\alias{ibm_values.bm_fm_mesh_1d}
\alias{ibm_jacobian.bm_fm_mesh_1d}
\alias{ibm_n.bm_inla_mesh_1d}
\alias{ibm_values.bm_inla_mesh_1d}
\alias{ibm_jacobian.bm_inla_mesh_1d}
\title{Mapper for \code{fm_mesh_1d}}
\usage{
\method{bru_mapper}{fm_mesh_1d}(mesh, indexed = TRUE, ...)

\method{ibm_n}{bm_fm_mesh_1d}(mapper, ...)

\method{ibm_values}{bm_fm_mesh_1d}(mapper, ...)

\method{ibm_jacobian}{bm_fm_mesh_1d}(mapper, input, ...)

\method{ibm_n}{bm_inla_mesh_1d}(mapper, ...)

\method{ibm_values}{bm_inla_mesh_1d}(mapper, ...)

\method{ibm_jacobian}{bm_inla_mesh_1d}(mapper, input, ...)
}
\arguments{
\item{mesh}{An \code{fm_mesh_1d} object to use as a mapper}

\item{indexed}{logical; If \code{TRUE} (default), the \code{ibm_values()} output will
be the integer indexing sequence for the latent variables (needed for
\code{spde} models). If \code{FALSE}, points representative of the basis centres
are returned (useful for an interpolator for \code{rw2} models and similar,
for \code{fmesher} versions \verb{>= 0.3.0.9002}).}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}
}
\value{
A \code{bm_fm_mesh_1d} or \code{bm_fmesher} object. The the
general \code{\link[=bm_fmesher]{bm_fmesher()}} mapper handles all indexed \code{fmesher}
objects.
}
\description{
Create mapper for an \code{fm_mesh_1d} object
}
\examples{
m <- bru_mapper(fm_mesh_1d(c(1:3, 5, 7)))
ibm_values(m)
ibm_eval(m, 1:7, 1:5)

m <- bru_mapper(fm_mesh_1d(c(1:3, 5, 7)), indexed = FALSE)
ibm_values(m)
ibm_eval(m, 1:7, 1:5)

m <- bru_mapper(
  fm_mesh_1d(c(1:3, 5, 7), degree = 2, boundary = "free"),
  indexed = FALSE
)
ibm_values(m)
ibm_eval(m, 1:7, 1:6)
}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
