% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_replace.R
\name{comparison_replace}
\alias{comparison_replace}
\alias{>=<-}
\alias{><-}
\alias{<=<-}
\alias{<<-}
\alias{==<-}
\alias{!=<-}
\title{Replacing Values by Comparison}
\usage{
x >= y <- value

x > y <- value

x <= y <- value

x < y <- value

x == y <- value

x != y <- value
}
\arguments{
\item{x}{first element of the operation.}

\item{y}{second element of the operation.}

\item{value}{replacement value.}
}
\value{
\code{x} with values for which the comparisons evaluate to TRUE replaced with \code{value}.
}
\description{
Operators for replacing values using the standard comparison operators.
}
\details{
Thanks to these operators :
\itemize{
\item \code{x == y <- value} is equivalent to \code{x[x == y] <- value}
\item \code{x != y <- value} is equivalent to \code{x[x != y] <- value}
\item \code{x <= y <- value} is equivalent to \code{x[x <= y] <- value}
\item \code{x >= y <- value} is equivalent to \code{x[x >= y] <- value}
\item \code{x < y <- value} is equivalent to \code{x[x < y] <- value}
\item \code{x > y <- value} is equivalent to \code{x[x > y] <- value}
}
}
\examples{
ages <- c(130, 10, 1996, 21, 39, 74, -2, 0)

ages == 1996 <- as.numeric(format(Sys.Date(), "\%Y")) - 1986
ages

ages > 100 <- NA
ages

ages <= 0 <- NA
ages

}
\seealso{
\code{`==`}
}
