% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isr.deconv.R
\name{isr.deconv}
\alias{isr.deconv}
\title{Insulin Secretion Rate Deconvolution}
\usage{
isr.deconv(
  timeseries,
  cpepseries,
  vol,
  shl,
  lhl,
  frc,
  method = c("linear", "spline"),
  plotspline = FALSE,
  plotisr = FALSE,
  isr.validated.vals,
  isr.validated.time
)
}
\arguments{
\item{timeseries}{Vector of numeric time values corresponding to the c-peptide values in \code{cpepseries}}

\item{cpepseries}{Vector of numeric c-peptide values at each time point in \code{timeseries}}

\item{vol}{Volume of distribution in the main compartment (i.e., serum volume), which can be calculated with the \code{\link[=isr.volume]{isr.volume()}} function}

\item{shl}{Short half-life, which can be calculated with the \code{\link[=isr.shortHL]{isr.shortHL()}} function}

\item{lhl}{Long half-life, which can be calculated with the \code{\link[=isr.longHL]{isr.longHL()}} function}

\item{frc}{Fraction attributable to the short half-life, which can be calculated with the \code{\link[=isr.fraction]{isr.fraction()}} function}

\item{method}{Determines whether C-peptide values are interpolated with linear connections between the points or a cubic spline}

\item{plotspline}{Dictates whether to print a plot of the C-peptide interpolation}

\item{plotisr}{Dictates whether to print a plot of the ISR output values}

\item{isr.validated.vals}{Used for debugging; validated ISR values to compare to past analyses}

\item{isr.validated.time}{Used for debugging; time values corresponding to validated ISR values to compare to past analyses}
}
\value{
If \code{method = "linear"} is selected (default), returns a list of time
points and insulin secretory rates. If \code{method = "spline"} is selected, returns
a function which can be called to return insulin secretory rates at specified
time points.
}
\description{
Estimates insulin secretion rate based on a time series of c-peptide values
based on the Van Cauter method. C-peptide values are interpolated using
either linear approximation or a cubic spline; the linear method (default)
will output a time series of insulin secretory rates at time points between
each input time, whereas the spline method will output a function which can
be called to return insulin secretory rates for specific time points.

Typically, c-peptide values are provided in pmol/mL and time is in minutes,
resulting in insulin secretion rate outputs in pmol/min.

Although this function was designed with insulin secretion in mind, it uses
a two-compartment secretion model that may be applied beyond insulin.
}
\examples{
isr.deconv(
  timeseries = c(-30, 0, 30, 60, 90, 120),
  cpepseries = c(1.72, 1.72, 5.40, 5.23, 2.71, 1.79),
  vol = 6104,
  shl = 4.55,
  lhl = 31.05,
  frc = 0.78,
  method = "linear",
  plotspline = TRUE,
  plotisr = TRUE,
)

}
\seealso{
\code{\link[=isr.volume]{isr.volume()}}, \code{\link[=isr.shortHL]{isr.shortHL()}}, \code{\link[=isr.longHL]{isr.longHL()}}, \code{\link[=isr.fraction]{isr.fraction()}}
}
