% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invictor.R
\name{regressors}
\alias{regressors}
\alias{\%/r\%}
\alias{\%/1\%}
\alias{\%/2\%}
\alias{\%/3\%}
\alias{\%/4\%}
\alias{\%/n\%}
\title{Regress vectors}
\usage{
x \%/r\% y

x \%/1\% y

x \%/2\% y

x \%/3\% y

x \%/4\% y

x \%/n\% yn
}
\arguments{
\item{x}{Numeric vectors}

\item{y}{Numeric vector}

\item{yn}{List of length 2, first element is a vector \code{y}, the second element an integer denoting the order of the polynomial regression.}
}
\description{
Regress vectors

Correlate x and y

Polynomial regression of degree 1

Polynomial regression of degree 2

Polynomial regression of degree 3

Polynomial regression of degree 4

`%/n%` Polynomial regression of degree n
}
\examples{

x <- rnorm(100)
y <- x + x^2 + x^3

# Correlate x with y
x\%/r\%y

# Polynomial regression degree 1 .. 4
x\%/1\%y
x\%/2\%y
x\%/3\%y
x\%/4\%y

anova(x\%/1\%y,x\%/2\%y,x\%/3\%y,x\%/4\%y)

# Order n

x\%/n\%list(y,10)

}
