% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tkstats_1comp.R
\name{tkstats_1comp}
\alias{tkstats_1comp}
\title{Toxicokinetic statistics for 1-compartment model}
\usage{
tkstats_1comp(pars, route, medium, dose, time_unit, conc_unit, vol_unit, ...)
}
\arguments{
\item{pars}{A named numeric vector of model parameters (e.g. from [coef.pk()]).}

\item{route}{Character: The route for which to compute TK stats. Currently
only "oral" and "iv" are supported.}

\item{medium}{Character: the media (tissue) for which to compute TK stats.
Currently only "blood" and "plasma" are supported.}

\item{dose}{Numeric: A dose for which to calculate TK stats.}

\item{time_unit}{Character: the units of time used for the parameters `par`.
For example, if `par["kelim"]` is in units of 1/weeks, then `time_unit =
"weeks"`. If `par["kelim"]` is in units of 1/hours, then `time_unit =
"hours"`. This is used to calculate the steady-state plasma/blood
concentration for long-term daily dosing of 1 mg/kg/day.}

\item{conc_unit}{Character: The units of concentration.}

\item{vol_unit}{Character: The units of dose.}

\item{...}{Additional arguments not currently in use.}
}
\value{
A `data.frame` with two variables:
- `param_name` = `c("CLtot", "CLtot/Fgutabs", "Css", "halflife", "tmax", "Cmax", "AUC_infinity")`
- `param_value` = The corresponding values for each statistic (which may be NA if that statistic could not be computed).
}
\description{
Calculate predicted toxicokinetic statistics for a 1-compartment model.
}
\section{Statistics computed}{


\subsection{Total clearance}{
\deqn{\textrm{CL}_{tot} = k_{elim} + V_{dist}}
}
\subsection{Steady-state plasma concentration for long-term daily dose of 1 mg/kg/day}{
The dosing interval \eqn{\tau = \frac{1}{\textrm{day}}} will be converted to
the same units as \eqn{k_{elim}}.

To convert to steady-state *blood* concentration, multiply by the
blood-to-plasma ratio.
\subsection{Oral route}{
\deqn{C_{ss} = \frac{F_{gutabs} V_{dist}}{k_{elim} \tau}}
}
\subsection{Intravenous route}{
\deqn{C_{ss} = \frac{1}{24 * \textrm{CL}_{tot}}}
}
}
\subsection{Half-life of elimination}{
\deqn{\textrm{Halflife} = \frac{\log(2)}{k_{elim}}}
}
\subsection{Time of peak concentration}{
For oral route:

\deqn{\frac{\log \left( \frac{k_{gutabs}}{k_{elim}} \right)}{k_{gutabs} -
k_{elim}}}

For intravenous route, time of peak concentration is always 0.
}
\subsection{Peak concentration}{
Evaluate [cp_1comp_cl()] at the time of peak concentration.
}
\subsection{AUC evaluated at infinite time}{
Evaluate [auc_1comp_cl()] at time = `Inf`.
}
\subsection{AUC evaluated at the time of the last observation}{
Evaluate [auc_1comp_cl()] at time = `tlast`.
}
}

\author{
John Wambaugh, Caroline Ring
}
