% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-croatia_2010_1800.R
\docType{data}
\name{croatia_2010_1800}
\alias{croatia_2010_1800}
\title{Input-output table for Croatia, 2010 (domestic production)}
\format{
A data frame with 13 variables:
\describe{
\item{t_rows2}{Technology codes in row names, following Eurostat
conventions.}
\item{t_rows2_lab}{Longer labels for \code{t_rows2}.}
\item{values}{Actual values of the table in thousand kunas.}
\item{t_cols2}{Column labels, following Eurostat conventions. A \code{CPA_}
suffix was added to original DZS column names.}
\item{t_cols2_lab}{Longer labels for \code{t_cols2}.}
\item{iotables_col}{Standardized \code{iotables} column labels for easier
reading.}
\item{col_order}{Column ordering to keep the matrix legible.}
\item{iotables_row}{Standardized \code{iotables} row labels for easier reading.}
\item{row_order}{Row ordering to keep the matrix legible.}
\item{unit}{Different from Eurostat tables, in thousand national currency
units.}
\item{geo}{ISO/Eurostat country code for Croatia.}
\item{geo_lab}{ISO/Eurostat country name, Croatia.}
\item{time}{Date of the SIOT.}
}
}
\source{
\href{https://dzs.gov.hr/}{Državni zavod za statistiku}
}
\usage{
croatia_2010_1800
}
\description{
Symmetric input-output table (SIOT) for domestic production (product ×
product), code \strong{1800}.

Values are expressed in thousand kunas (T_NAC).
}
\seealso{
Other Croatia 2010 datasets: 
\code{\link{croatia_2010_1700}},
\code{\link{croatia_2010_1900}},
\code{\link{croatia_employment_2013}},
\code{\link{croatia_employment_aggregation}},
\code{\link{primary_inputs}}
}
\concept{Croatia 2010 datasets}
\keyword{datasets}
