% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primary_input_get.R
\name{primary_input_get}
\alias{primary_input_get}
\title{Get a primary input row}
\usage{
primary_input_get(data_table, primary_input = "compensation_employees")
}
\arguments{
\item{data_table}{A symmetric I–O table, use table, or supply table as
returned by \code{\link[=iotable_get]{iotable_get()}}.}

\item{primary_input}{Character. The primary input to return. Accepts common
synonyms (e.g., "compensation of employees", "cfc", "taxes on production",
"operating surplus", "imports").}
}
\value{
A data frame containing the key column and the matching primary-
input row.
}
\description{
Retrieve a named primary-input row from a symmetric input–output table,
a use table, or a supply table (as returned by \code{\link[=iotable_get]{iotable_get()}}).
}
\details{
In I–O accounting, \emph{primary inputs} (e.g., compensation of employees,
consumption of fixed capital, taxes on production/subsidies, operating
surplus/mixed income, and—when relevant—imports used for domestic
production) are shown in the value-added block (third quadrant).
}
\examples{
# Get the Germany 1995 demo SIOT with default labelling
de_iot <- iotable_get(source = "germany_1995")

# Select compensation of employees (row code: "compensation_employees")
primary_input_get(de_iot, "compensation_employees")

# Get the same table with Eurostat short labelling
de_iot_short <- iotable_get(source = "germany_1995", labelling = "short")

# Consumption of fixed capital (row code: "K1")
primary_input_get(de_iot_short, "K1")

# Operating surplus and mixed income, net (row code: "B2A3N")
primary_input_get(de_iot_short, "B2A3N")
}
\references{
Eurostat (2008). \emph{Eurostat Manual of Supply, Use and Input–Output Tables},
ch. 13.
United Nations (2018). \emph{Handbook on Supply and Use Tables and Input–Output
Tables with Extensions and Applications (Rev. 1, “white cover”)}, ch. 10.
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
