% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional_functions.R
\name{check_dgf}
\alias{check_dgf}
\title{Check for Different Guidance Functioning (DGF)}
\usage{
check_dgf(
  data,
  splitcr,
  random_starts = 300,
  max_iterations = 5000,
  cr_rel_change = 1e-12,
  con_step_size = 1e-04,
  con_random_starts = 10,
  con_max_iterations = 5000,
  con_rel_convergence = 1e-12,
  b_min = 0.01,
  trace = FALSE,
  con_trace = FALSE,
  fast = TRUE
)
}
\arguments{
\item{data}{Data for which the elements should be estimated. Data must be
an object of type \code{data.frame} or \code{matrix} with cases in the rows and
raters in the columns. Please note that no additional variables are allowed
in this object.}

\item{splitcr}{\code{Vector} containing the assignments of coding units to
groups. The vector must have the same length as the number of rows of object
\code{data}.}

\item{random_starts}{An integer for the number of random starts for the
EM algorithm.}

\item{max_iterations}{An integer for the maximum number of iterations within
the EM algorithm.}

\item{cr_rel_change}{Positive numeric value for defining the convergence of the
EM algorithm.}

\item{con_step_size}{\code{Double} for specifying the size for increasing or
decreasing the probabilities during the conditioning stage of estimation.
This value should not be less than 1e-3.}

\item{con_random_starts}{\code{Integer} for the number of random starts
within the condition stage.}

\item{con_max_iterations}{\code{Integer} for the maximum number of iterations
during the condition stage.}

\item{con_rel_convergence}{\code{Double} for determining the convergence
criterion during condition stage. The algorithm stops if the relative change
is smaller than this criterion.}

\item{b_min}{Value ranging between 0 and 1 determining the minimal size of
the categories for checking if boundary values occurred. The algorithm tries
to select solutions that are not considered to be boundary values.}

\item{trace}{\code{TRUE} for printing progress information on the console.
\code{FALSE} if this information is not to be printed.}

\item{con_trace}{\code{TRUE} for printing progress information on the console
during estimations in the condition stage. \code{FALSE} if this information
is not to be printed.}

\item{fast}{\code{Bool} If \code{TRUE} a fast estimation is applied during the
condition stage. This option ignores all parameters beginning with "con_".
If \code{FALSE} the estimation described in Berding and
Pargmann (2022) is used. Default is \code{TRUE}.}
}
\value{
Returns an object of class \code{iotarelr_iota2_dif}. For each group,
the results of the estimation are saved separately. The structure within each
group is similar to the results from \code{compute_iota2()}. Please check
that documentation.
}
\description{
Function for checking if the coding scheme is the same for different sub-groups.
}
\references{
Florian Berding and Julia Pargmann (2022).Iota Reliability Concept
of the Second Generation. Measures for Content Analysis Done by
Humans or Artificial Intelligences. Berlin:Logos.
https://doi.org/10.30819/5581
}
