% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_phonetics.R
\name{convert_phonetics}
\alias{convert_phonetics}
\title{Convert between phonetic representations}
\usage{
convert_phonetics(
  x,
  from = c("ipa", "xsampa", "arpabet"),
  to = c("ipa", "xsampa", "arpabet")
)
}
\arguments{
\item{x}{A phonetic character vector in IPA, X-SAMPA, or ARPABET}

\item{from}{The phonetic alphabet to convert from}

\item{to}{The phonetic alphabet to convert to.
\code{"sampa"} is an accepted alias for \code{"xsampa"}.
\code{"arpa"} and \code{"cmu"} are accepted aliases for \code{"arpabet"}.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Converts between IPA, X-SAMPA and ARPABET (used by the CMU Pronouncing
Dictionary)
}
\examples{
convert_phonetics('\%hE"loU', from = "xsampa", to = "ipa")
convert_phonetics(c('\%hE"loU', "w3`ld"), from = "xsampa", to = "ipa")
convert_phonetics('\%hE"loU', from = "xsampa", to = "arpabet")
convert_phonetics(c('\%hE"loU', "w3`ld"), from = "xsampa", to = "arpabet")

convert_phonetics('HH EH L OW', from = "arpabet", to = "ipa")
convert_phonetics(c('HH EH L OW', "W ER L D"), from = "arpabet", to = "ipa")
convert_phonetics('HH EH L OW', from = "arpabet", to = "xsampa")
convert_phonetics(c('HH EH L OW', "W ER L D"), from = "arpabet", to = "xsampa")

# `convert_phonetics()` supports raw Unicode input or escaped Unicode sequences
# (\uxxxx), but raw Unicode is not supported in R package documentation,
# hence the ugly examples
convert_phonetics("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a", from = "ipa", to = "xsampa")
convert_phonetics(
  c("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a", "w\\\\u025dld"), from = "ipa", to = "xsampa"
)
convert_phonetics("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a", from = "ipa", to = "arpabet")
convert_phonetics(
  c("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a", "w\\\\u025dld"), from = "ipa", to = "arpabet"
)
}
\seealso{
\code{\link[=ipa]{ipa()}} to convert from IPA

\code{\link[=sampa]{sampa()}} and \code{\link[=xsampa]{xsampa()}} to convert from X-SAMPA

\code{\link[=arpa]{arpa()}}, \code{\link[=arpabet]{arpabet()}} and \code{\link[=cmu]{cmu()}} to convert from ARPABET (CMU)
}
