% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_files.R
\name{ipums_list_files}
\alias{ipums_list_files}
\title{List files contained within a zipped IPUMS extract}
\usage{
ipums_list_files(file, file_select = NULL, types = NULL)
}
\arguments{
\item{file}{Path to a .zip archive containing the IPUMS extract to be
examined.}

\item{file_select}{If the path in \code{file} contains multiple files, a
\link[=selection_language]{tidyselect selection} identifying the files to be
included in the output. Only files that match the provided expression
will be included.

While less useful, this can also be provided as a string specifying an
exact file name or an integer to match files by index position.}

\item{types}{One or more of \code{"data"}, \code{"shape"}, or \code{"codebook"} indicating
the type of files to include in the output. \code{"data"} refers to
tabular data sources, \code{"shape"} refers to spatial data sources, and
\code{"codebook"} refers to metadata text files that accompany data files.}
}
\value{
A \code{\link[tibble:tbl_df-class]{tibble}} containing the types and names of
the available files.
}
\description{
Identify the files that can be read from an IPUMS extract.
}
\examples{
nhgis_file <- ipums_example("nhgis0712_csv.zip")

# 2 available data files in this extract (with codebooks)
ipums_list_files(nhgis_file)

# Look for files that match a particular pattern:
ipums_list_files(nhgis_file, file_select = matches("ds136"))
}
\seealso{
\code{\link[=read_ipums_micro]{read_ipums_micro()}} or \code{\link[=read_ipums_agg]{read_ipums_agg()}} to read tabular data
from an IPUMS extract.

\code{\link[=read_ipums_sf]{read_ipums_sf()}} to read spatial data from an IPUMS extract.
}
