% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_correct_atmosphere.R
\name{ir_correct_atmosphere}
\alias{ir_correct_atmosphere}
\title{Corrects artifacts in a spectrum based on reference spectra of the artifact compound}
\source{
\insertAllCited{}
}
\usage{
ir_correct_atmosphere(
  x,
  ref,
  wn1,
  wn2,
  return_contribution = FALSE,
  do_interpolate = FALSE,
  start = NULL,
  dw = 1,
  warn = TRUE,
  return_ir_flat = FALSE
)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}} containing the spectra to
correct (with intensities representing absorbances).}

\item{ref}{An object of class \code{\link[=ir_new_ir]{ir}} containing the reference
spectra to use for correction  (with intensities representing absorbances).
\code{ref} must have the same number of rows as \code{x}, the contained spectra must
cover the wavenumber range of all spectra in \code{x}, and if
\code{do_interpolate = FALSE}, all spectra must have identical wavenumber values.}

\item{wn1}{A numeric value representing the first wavenumber value to use as
reference point \insertCite{Perez-Guaita.2013}{ir}. Examples used by
\insertCite{Perez-Guaita.2013;textual}{ir} are:
\describe{
\item{H\eqn{_2}O}{3902 cm\eqn{^{-1}}.}
\item{CO\eqn{_2}}{2361 cm\eqn{^{-1}}.}
}}

\item{wn2}{A numeric value representing the second wavenumber value to use as
reference point \insertCite{Perez-Guaita.2013}{ir}. Examples used by
\insertCite{Perez-Guaita.2013;textual}{ir} are:
\describe{
\item{H\eqn{_2}O}{3912 cm\eqn{^{-1}}.}
\item{CO\eqn{_2}}{2349 cm\eqn{^{-1}}.}
}}

\item{return_contribution}{A logical value indicating whether in addition to
the corrected spectra, the computed relative contribution of \code{ref} to each
spectrum in \code{x} should be added to the returned object as new column
\code{contribution} (\code{TRUE}) or not (\code{FALSE}).}

\item{do_interpolate}{A logical value indicating if \code{x} and \code{ref} should be
interpolated prior correction (\code{TRUE}) or not (\code{FALSE}).}

\item{start}{See \code{\link[=ir_interpolate]{ir_interpolate()}}.}

\item{dw}{See \code{\link[=ir_interpolate]{ir_interpolate()}}.}

\item{warn}{A logical value indicating whether warnings about mismatching
wavenumber values should be displayed (\code{TRUE}) or not (\code{FALSE}). If set to
\code{TRUE} and \code{wn1} or \code{wn2} do not exactly match the wavenumber values in \code{x}
and \code{ref}, a warning will be printed to inform about the wavenumber
difference between the selected and targeted wavenumber value.}

\item{return_ir_flat}{Logical value. If \code{TRUE}, the spectra are returned as
\code{\link[=ir_new_ir_flat]{ir_flat}} object.}
}
\value{
\code{x} corrected with the reference spectra in \code{ref}.
}
\description{
\code{ir_correct_atmosphere} takes two objects of class \code{ir} with the same number
of spectra in each and corrects the spectra of the first object with the
spectra of the second object according to the procedure presented by
\insertCite{Perez-Guaita.2013}{ir}.
}
\examples{
x1 <-
  ir_correct_atmosphere(
    ir_sample_data[1:5, ], ir_sample_data[1:5, ], wn1 = 2361, wn2 = 2349
  )

x2 <-
  ir_correct_atmosphere(
    ir_sample_data[1:5, ], ir_sample_data[1:5, ], wn1 = 2361, wn2 = 2349,
    return_contribution = TRUE
  )

x2$contribution

}
