% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_sample_prospectr.R
\name{ir_sample_prospectr}
\alias{ir_sample_prospectr}
\title{Wrapper to sampling functions from the 'prospectr' package}
\usage{
ir_sample_prospectr(x, sampling_function, ..., return_prospectr_output = FALSE)
}
\arguments{
\item{x}{An object of class 'ir' containing the spectra based on which
to sample measurements.}

\item{sampling_function}{A function from the 'prospectr' package to perform
sampling based on spectra (\code{naes()}, \code{kenStone()}, \code{duplex()}, \code{puchwein()},
\code{shenkWest()}, \code{honig()}). See the 'prospectr' package for details.}

\item{...}{Arguments passed to \code{sampling_function}. See the 'prospectr'
package for details.}

\item{return_prospectr_output}{Logical value. If \code{TRUE}, the output of
\code{sampling_function} is returned. If \code{FALSE}, values of elements \code{model}
and \code{test} are included as columns in \code{x} and \code{x} is returned.}
}
\value{
If \code{return_prospectr_output = TRUE}, the output of \code{sampling_function}. See
the 'prospectr' package for details. If \code{return_prospectr_output = FALSE},\code{x}
with the following additional columns:
\describe{
\item{for_prospectr_model}{Logical value indicating whether the spectrum is
listed in element \code{model} of the prospectr output (\code{TRUE}) or not
(\code{FALSE}).}
\item{for_prospectr_test}{Logical value indicating whether the spectrum is
listed in element \code{test} of the prospectr output (\code{TRUE}) or not
(\code{FALSE}).}
\item{prospectr_model}{Integer representing the order in which spectra are
listed in element \code{model} of the prospectr output.}
\item{prospectr_test}{Integer representing the order in which spectra are
listed in element \code{test} of the prospectr output.}
}
}
\description{
Wrapper functions that allows to directly use 'ir' objects with sampling
functions from the 'prospectr' package.
}
\examples{
if(requireNamespace("prospectr", quietly = TRUE)) {
  x <-
    ir_sample_prospectr(
      ir::ir_sample_data,
      prospectr::kenStone,
      metric = "euclid",
      k = 30,
      return_prospectr_output = FALSE
  )

  x <-
    ir_sample_prospectr(
      ir::ir_sample_data,
      prospectr::kenStone,
      metric = "euclid",
      k = 30,
      return_prospectr_output = TRUE
    )
}

}
