% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree.coeff3.raw.r
\name{fleiss.kappa.raw}
\alias{fleiss.kappa.raw}
\title{Fleiss' generalized kappa among multiple raters (2, 3, +) when the input data represent the raw ratings reported for each subject and each rater.}
\usage{
fleiss.kappa.raw(ratings, weights = "unweighted", categ.labels = NULL,
  conflev = 0.95, N = Inf)
}
\arguments{
\item{ratings}{An nxr matrix / data frame of ratings where each column represents one rater and each row one subject.}

\item{weights}{is a mandatory parameter that is either a string variable or a matrix. 
The string describes one of the predefined weights and must take one of the values 
("quadratic", "ordinal", "linear", "radical", "ratio", "circular", "bipolar"). 
If this parameter is a matrix then it must be a square matri qxq where q is the number 
of posssible categories where a subject can be classified. If some of the q possible 
categories are not used, then it is strobgly advised to specify the complete list of 
possible categories as a vector in parametr categ.labels. Otherwise, the program may not work.}

\item{categ.labels}{An optional vector parameter containing the list of all possible ratings. It may be useful in 
case some of the possibe ratings are not used by any rater, they will still be used when calculating agreement 
coefficients. The default value is NULL. In this case, only categories reported by the raters are used in the
calculations.}

\item{conflev}{An optional parameter representing the confidence level associated with the confidence interval. Its default value is 0.95.}

\item{N}{An optional parameter representing the population size (if any). It may be use to perform the final population correction to the variance.  Its default value is infinity.}
}
\value{
A data list containing 3 objects: (1) a one-row data frame containing various statistics including the 
requested agreement coefficient, (2) the weight matrix used in the calculations if any, and (3) the categories 
used in the analysis. These could be categories reported by the raters, or those that were available to the raters
whether they used them or not.  The output data frame contains the following variables: "coeff.name" 
(coefficient name-here it will be "Fleiss' Kappa"), "pa" (the percent agreement), "pe" (the percent chance agreement), coeff.val 
(the agreement coefficient estimate-Fleiss' Kappa), "coeff.se" (the standard error), "conf.int" (Fleiss Kappa's confidence 
interval), "p.value"(Fleiss Kappa's p-value), "w.name"(the weights' identification).
}
\description{
Fleiss' generalized kappa among multiple raters (2, 3, +) when the input data represent the raw ratings reported for each subject and each rater.
}
\examples{
#The dataset "cac.raw4raters" comes with this package. Analyze it as follows:
cac.raw4raters
fleiss.kappa.raw(cac.raw4raters) #Fleiss' kappa, precision measures, weights & categories
fleiss.kappa.raw(cac.raw4raters)$est #Yields Fleiss' kappa with precision measures
fleiss <- fleiss.kappa.raw(cac.raw4raters)$est$coeff.val #Yields Fleiss' kappa alone.
fleiss
fleiss.kappa.raw(cac.raw4raters, weights = "quadratic") #weighted Fleiss' kappa/quadratic wts
}
\references{
Fleiss, J. L. (1981). \emph{Statistical Methods for Rates and Proportions}. John Wiley \& Sons.
}
