% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarking.r
\name{landis.koch.bf}
\alias{landis.koch.bf}
\title{Computing Landis-Koch Benchmark Scale Membership Probabilities}
\usage{
landis.koch.bf(coeff, se, BenchDF = landis.koch)
}
\arguments{
\item{coeff}{A mandatory parameter representing the estimated value of an agreement coefficient.}

\item{se}{A mandatory parameter representing the agreement coefficient standard error.}

\item{BenchDF}{An optional parameter that is a 3-column data frame containing the Landis \& Koch's benchmark scale 
information. The 3 columns are the interval lower bound, upper bound, and their interpretation. The default value 
is a small file contained in the package and named \emph{landis.koch.RData}, which describes the official 
Landis \& Koch's scale intervals and their interpretation.}
}
\value{
A one-column matrix containing the membership probabilities (c.f. \url{http://agreestat.com/research_papers/inter-rater\%20reliability\%20study\%20design1.pdf})
}
\description{
Computing Landis-Koch Benchmark Scale Membership Probabilities
}
