% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_df_fipc.R
\name{shape_df_fipc}
\alias{shape_df_fipc}
\title{Combine fixed and new item metadata for fixed-item parameter calibration
(FIPC)}
\usage{
shape_df_fipc(x, fix.loc = NULL, item.id = NULL, cats, model)
}
\arguments{
\item{x}{A data.frame of metadata for items whose parameters remain fixed
(e.g., output from \code{\link[=shape_df]{shape_df()}}).}

\item{fix.loc}{An integer vector specifying the row positions in the final
output where fixed items should be placed.}

\item{item.id}{A character vector of IDs for new items whose parameters will
be estimated.If \code{NULL}, default IDs (e.g., "V1", "V2", ...) are assigned
automatically.}

\item{cats}{An integer vector indicating the number of response categories
for each new item; order must match \code{item.id}.}

\item{model}{A character vector of IRT model names for each new item. Valid
options for dichotomous items: "1PLM", "2PLM", "3PLM", "DRM"; for
polytomous items: "GRM", "GPCM".}
}
\value{
A data.frame containing combined metadata for all items (fixed and
new), ordered by test position.
}
\description{
This function merges existing fixed-item metadata with automatically
generated metadata for new items, producing a single data frame ordered by
specified test positions, to facilitate fixed item parameter calibration
using \code{\link[=est_irt]{est_irt()}}.
}
\details{
To use this function, first prepare a metadata frame \code{x} containing
only fixed items—either created by \code{\link[=shape_df]{shape_df()}} or imported from
external software (e.g., via \code{\link[=bring.flexmirt]{bring.flexmirt()}}), which must include
columns \code{id}, \code{cats}, \code{model}, and all relevant parameter columns (\code{par.1},
\code{par.2}, etc.). The \code{fix.loc} argument should then specify the exact row
positions in the final test form where these fixed items should remain. The
length of \code{fix.loc} must match the number of rows in \code{x}, and the order of
positions in \code{fix.loc} determines where each fixed-item row is placed.

Next, provide information for the new items whose parameters will be
estimated. Supply vectors for \code{item.id}, \code{cats}, and \code{model} matching the
number of new items (equal to total form length minus length of \code{fix.loc}).
If \code{item.id} is \code{NULL}, unique IDs are generated automatically.
}
\examples{
## Import the flexMIRT parameter output file
prm_file <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtQ")
x_fixed <- bring.flexmirt(file = prm_file, "par")$Group1$full_df

## Define positions of fixed items in the test form
fixed_pos <- c(1:40, 43:57)

## Specify IDs, models, and category counts for new items
new_ids <- paste0("NI", 1:6)
new_models <- c("3PLM", "1PLM", "2PLM", "GRM", "GRM", "GPCM")
new_cats <- c(2, 2, 2, 4, 5, 6)

## Generate combined metadata for FIPC
shape_df_fipc(x = x_fixed, fix.loc = fixed_pos, item.id = new_ids,
  cats = new_cats, model = new_models)

}
\seealso{
\code{\link[=shape_df]{shape_df()}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
