% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{cdf}
\alias{cdf}
\alias{cdf.idr}
\alias{cdf.data.frame}
\title{Cumulative distribution function (CDF) of IDR or raw forecasts}
\usage{
cdf(predictions, thresholds)

\method{cdf}{idr}(predictions, thresholds)

\method{cdf}{data.frame}(predictions, thresholds)
}
\arguments{
\item{predictions}{either an object of class \code{idr} (output of
\code{\link{predict.idrfit}}), or a \code{data.frame} of numeric variables.
In the latter case, the CDF is computed using the empirical distribution of
the variables in \code{predictions}.}

\item{thresholds}{numeric vector of thresholds at which the CDF will be
evaluated.}
}
\value{
A matrix of probabilities giving the evaluated CDFs at the given thresholds,
one column for each threshold.
}
\description{
Evaluate the the cumulative distribution function (CDF) of IDR predictions or
of unprocessed forecasts in a \code{data.frame}.
}
\details{
The CDFs are considered as piecewise constant stepfunctions: If \code{x} are
the points where the IDR fitted CDF (or the empirical distribution of the
forecasts) has jumps and \code{p} the corresponding CDF values, then for
\code{x[i] <= x < x[i + 1]}, the CDF at \code{x} is \code{p[i]}.
}
\examples{

data("rain")

## Postprocess HRES forecast using data of 3 years

X <- rain[1:(3 * 365), "HRES", drop = FALSE]
y <- rain[1:(3 * 365), "obs"]

fit <- idr(y = y, X = X)

## Compute probability of precipitation given that the HRES forecast is
## 0 mm, 0.5 mm or 1 mm

predictions <- predict(fit, data = data.frame(HRES = c(0, 0.5, 1)))
1 - cdf(predictions, thresholds = 0)
}
\seealso{
\code{\link{predict.idrfit}} \code{\link{qpred}}, \code{\link{bscore}}
}
