% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{orbi_flag_satellite_peaks}
\alias{orbi_flag_satellite_peaks}
\title{Flag minor satellite peaks
Flags minor signals for an isotopocule that matches multiple peaks within its exact mass +/- tolerance interval in the same scan. These are often small satellite peaks generated by the Fourier transform.
However, if there are satelite peaks of high intensity or very many satellite peaks, it can indicate that the m/z and tolerance setting used for identifying isotopcules need to be revisited.
Visualize the flagged satellite peaks with \code{\link[=orbi_plot_satellite_peaks]{orbi_plot_satellite_peaks()}}.}
\usage{
orbi_flag_satellite_peaks(dataset)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}
}
\value{
same object as provided in \code{dataset} with new column \code{is_satellite_peak} that flags satellite peaks
}
\description{
Flag minor satellite peaks
Flags minor signals for an isotopocule that matches multiple peaks within its exact mass +/- tolerance interval in the same scan. These are often small satellite peaks generated by the Fourier transform.
However, if there are satelite peaks of high intensity or very many satellite peaks, it can indicate that the m/z and tolerance setting used for identifying isotopcules need to be revisited.
Visualize the flagged satellite peaks with \code{\link[=orbi_plot_satellite_peaks]{orbi_plot_satellite_peaks()}}.
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <-
  orbi_read_isox(file = fpath) |>
  orbi_simplify_isox() |>
  orbi_flag_satellite_peaks()

}
