% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural-resources-clasifications.R
\name{get_structuralresources_codelists_agency_resource_version_codes}
\alias{get_structuralresources_codelists_agency_resource_version_codes}
\title{Get codelists agency resource version codes}
\usage{
get_structuralresources_codelists_agency_resource_version_codes(
  agencyid,
  resourceid,
  version,
  limit = 1000,
  offset = 0,
  query = "",
  orderby = "",
  openness = "",
  order = "",
  fields = "",
  lang = "es",
  as_dataframe = T
)
}
\arguments{
\item{agencyid}{(string): Agency identificator.}

\item{resourceid}{(string): Resource identificator.}

\item{version}{(string): Specific resource version.}

\item{limit}{(int): Results limit. By default \code{limit = 25}.}

\item{offset}{(int): Displacement. Result from which it is returned. By default \code{offset = 0}.}

\item{query}{(string): Query to filter the results. orderby (string): Field by which to sort the results.}

\item{orderby}{(string): Order established for data.}

\item{openness}{(string): Opening established for viewing.}

\item{order}{(string): Order established for visualization.}

\item{fields}{(string): Additional fields that you want to show in the answer.}

\item{lang}{(string): Language in which you want to get the answer.}

\item{as_dataframe}{(bool): If True, this function returns a pandas dataframe built from API response.}
}
\description{
This function allows to consult the codes of a version of a classification. Note that
if wildcards are used as \code{~all} or one of the \code{limit}, \code{offset}, \code{query} or
\code{orderBy} parameters, the list will be automatically paginated.
}
\examples{
get_structuralresources_codelists_agency_resource_version_codes(
"ISTAC",
"CL_AREA_ES",
"01.000"
)
}
