% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_optsamplesize_iHp.R
\name{optsamplesize_iHp}
\alias{optsamplesize_iHp}
\title{Compute the optimal sample size for the improved trimmed weighted Hochberg procedure}
\usage{
optsamplesize_iHp(
  alpha,
  k,
  betavec,
  deltavec,
  rho,
  ninterval = c(2, 2000),
  alphalist = seq(from = 0, to = alpha, by = 0.005)
)
}
\arguments{
\item{alpha}{the significance level}

\item{k}{a pre-specified constant in the improved trimmed weighted Hochberg procedure}

\item{betavec}{a numeric vector of two values, including one minus the desired power for rejecting H1 and one minus the desired power for rejecting H2}

\item{deltavec}{a numeric vector of two values representing the effect sizes for the two hypotheses}

\item{rho}{the correlation coefficient between two test statistics}

\item{ninterval}{a vector containing the end-points of the interval to be searched for optimal sample size}

\item{alphalist}{a vector of discrete alpha values}
}
\value{
the overall optimal sample size for the improved trimmed weighted Hochberg procedure
}
\description{
Compute the optimal sample size for the improved trimmed weighted Hochberg procedure
}
\examples{
rrr <- 2 # Allocation ratio
alpha <- 0.025
k <- 2/3
ninterval <- c(2, 1000)
betavec <- c(0.05, 0.15)
rho <- 0.3
psivec <- c(0.67, 0.73)
thetavec <- log(psivec)
deltavec <- (-thetavec)*sqrt(rrr)/(1+rrr)
result <- optsamplesize_iHp(alpha = alpha, k = k,
betavec = betavec, deltavec = deltavec,
rho = rho, ninterval = ninterval)
result$nopt
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
