% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{dispersion}
\alias{dispersion}
\title{Calculate the dispersion of the residuals}
\usage{
dispersion(model)
}
\arguments{
\item{model}{A fitted regression model (using gam, or bam).}
}
\value{
Numeric value: dispersion of the residuals.
}
\description{
Calculate the dispersion of the residuals
}
\examples{
trial <- function(f=.95){
    x <- rep(1-f,101)
    x[round(runif(1,1,50)):length(x)] <- f
    return(rbinom(101,1,x))
}
set.seed(123)
dat <- data.frame(Time=rep( seq(0,1,length=101),100),
    y = unlist(replicate(100, trial(f=1), simplify=FALSE)),
    stringsAsFactors=FALSE)
# under dispersion:
gam1 <- gam(y ~ s(Time), data=dat, family=binomial)
summary(gam1)
dispersion(gam1)
# but not here:
gam2 <- gam(y ~ 1, data=dat, family=binomial)
summary(gam2)
dispersion(gam2)
# and not here:
dat <- data.frame(Time=rep( seq(0,1,length=101),100),
    y = unlist(replicate(100, trial(f=.75), simplify=FALSE)),
    stringsAsFactors=FALSE)
gam3 <- gam(y ~ s(Time), data=dat, family=binomial)
summary(gam3)
dispersion(gam3)

}
\seealso{
Other Functions for model inspection: 
\code{\link{fvisgam}()},
\code{\link{gamtabs}()},
\code{\link{inspect_random}()},
\code{\link{plot_data}()},
\code{\link{plot_parametric}()},
\code{\link{plot_smooth}()},
\code{\link{plot_topo}()},
\code{\link{pvisgam}()}
}
\concept{Functions for model inspection}
