% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span.R
\name{iv_span}
\alias{iv_span}
\title{Span}
\usage{
iv_span(x, ..., missing = "propagate", empty = "missing")
}
\arguments{
\item{x}{\verb{[iv]}

An interval vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{missing}{\verb{["propagate" / "drop" / "error" / iv(1)]}

Handling of missing intervals in \code{x}.
\itemize{
\item \code{"propagate"} forces \code{iv_span()} to return a missing interval if any
missing intervals are detected in \code{x}.
\item \code{"drop"} drops missing intervals before computing the span. If this
results in an empty vector, then \code{empty} will be applied.
\item \code{"error"} throws an error if any missing intervals are detected.
\item If an iv of size 1 is supplied, then this is returned if any missing
intervals are detected. It is cast to the type of \code{x} before returning.
}}

\item{empty}{\verb{["missing" / "error" / iv(1)]}

Handling of empty \code{x} vectors.
\itemize{
\item \code{"missing"} forces \code{iv_span()} to return a missing interval if \code{x} is
empty.
\item \code{"error"} throws an error if \code{x} is empty.
\item If an iv of size 1 is supplied, then this is returned if \code{x} is empty. It
is cast to the type of \code{x} before returning.
}}
}
\description{
\code{iv_span()} computes the span of an iv. The span is a single interval which
encompasses the entire range of the iv. It is similar to \code{\link[=iv_groups]{iv_groups()}}, if
groups were also merged across gaps.

\code{iv_span()} is a \emph{summary} function, like \code{\link[=min]{min()}} and \code{\link[=max]{max()}}, so it always
returns a size 1 iv, even for empty ivs. The \code{empty} argument can be used to
control what is returned in the empty case.
}
\details{
\code{iv_span()} is currently limited by the fact that it calls \code{\link[=min]{min()}} and
\code{\link[=max]{max()}} internally, which doesn't work for all vector types that ivs
supports (mainly data frames). In the future, we hope to be able to leverage
\code{vctrs::vec_min()} and \code{vctrs::vec_max()}, which don't exist yet.
}
\examples{
x <- iv_pairs(c(1, 5), c(2, 6), c(9, 10))

# The span covers the full range of values seen in `x`
iv_span(x)

# Compare against `iv_groups()`, which merges overlaps but doesn't merge
# across gaps
iv_groups(x)

x <- iv_pairs(c(1, 3), c(NA, NA), c(5, 6), c(NA, NA))

# Because `iv_span()` is a summary function, if any missing intervals are
# present then it returns a missing interval by default
iv_span(x)

# Further control this with `missing`
iv_span(x, missing = "drop")
try(iv_span(x, missing = "error"))
iv_span(x, missing = iv(-1, 0))

x <- iv(double(), double())

# If `x` is empty, then by default a missing interval is returned
iv_span(x)

# Control this with `empty`
try(iv_span(x, empty = "error"))
iv_span(x, empty = iv(-Inf, Inf))

# `empty` kicks in if `missing = "drop"` is used and all elements were
# missing
x <- iv(c(NA, NA), c(NA, NA), ptype = double())
iv_span(x, missing = "drop", empty = iv(-Inf, Inf))
}
