% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.rahman.R
\name{jaccard.rahman}
\alias{jaccard.rahman}
\title{Compute p-value using the EC-BLAST method}
\usage{
jaccard.rahman(j)
}
\arguments{
\item{j}{a numeric vector of observed Jaccard coefficients (uncentered)}
}
\value{
\code{jaccard.rahman} returns a numeric vector of p-values
}
\description{
In the EC-BLAST paper, Rahman et al. (2014) provide the following description:
The mean (\eqn{\mu}) and s.d. (\eqn{\sigma}) of the similarity scores are used to
define the z score, \eqn{z = (Tw - \mu)/\sigma}. For the purpose of calculating
the P value, only hits with T > 0 are considered. The P value w
is derived from the z score using an extreme value distribution
\eqn{P = 1 - \exp\left(-e^{-z\pi/\sqrt{6} - \Gamma'(1)}\right)}, where the Euler-Mascheroni constant \eqn{\Gamma'(1) \approx 0.577215665}.
}
\references{
Rahman, Cuesta, Furnham, Holliday, and Thornton (2014) EC-BLAST: a tool to automatically search and compare enzyme reactions. Nature Methods, 11(2) \url{https://www.nature.com/articles/nmeth.2803}
}
