% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{makeColorDarker}
\alias{makeColorDarker}
\title{make R colors darker (or lighter)}
\usage{
makeColorDarker(
  hexColor,
  darkFactor = 2,
  sFactor = 1,
  fixAlpha = NULL,
  verbose = FALSE,
  keepNA = FALSE,
  useMethod = 1,
  ...
)
}
\arguments{
\item{hexColor}{\code{character} vector of colors to adjust}

\item{darkFactor}{\code{numeric} value to adjust darkness, values above 1
make the color darker, values below 1 (or below 0) make the color
brighter.}

\item{sFactor}{\code{numeric} value to adjust saturation, values above 1
become more saturated.}

\item{fixAlpha}{\code{numeric}, default NULL, to assign a fixed alpha
transparency value, where 0 is transparent and 1 is opaque.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{keepNA}{\code{logical}, default FALSE, whether to keep NA values
as NA values in the output, otherwise NA values are considered grey
input.}

\item{useMethod}{\code{integer} with two alternate methods, \code{1} is default.}

\item{...}{Additional arguments are ignored.}
}
\value{
\code{character} vector of R colors.
}
\description{
Makes R colors darker or lighter based upon darkFactor
}
\details{
This function was originally intended to create border colors, or to
create slightly darker colors used for labels. It is also useful for
for making colors lighter, in adjusting color saturation up or down,
or applying alpha transparency during the same step.

Note when colors are brightened beyond value=1, the saturation is
gradually reduced in order to produce a visibly lighter color. The
saturation minimu is set to 0.2, to maintain at least some amount of
color.
}
\examples{
colorV <- c("red","orange","purple","blue");
colorVdark2 <- makeColorDarker(colorV, darkFactor=2);
colorVlite2 <- makeColorDarker(colorV, darkFactor=-2);
showColors(cexCellnote=0.7,
   list(
   `darkFactor=2`=colorVdark2,
   `original colors`=colorV,
   `darkFactor=-2`=colorVlite2
   ));

# these adjustments work really well inside a network diagram
# when coloring nodes, and providing an outline of comparable
# color.
plot(x=c(1,2,1,2), y=c(1,2,2,1), pch=21,
   xaxt="n", yaxt="n", xlab="", ylab="",
   xlim=c(0.5,2.5), ylim=c(0.5,2.5),
   bg=colorV, col=colorVdark2, cex=4, lwd=2);
graphics::points(x=c(1,2,1,2), y=c(1,2,2,1), pch=20, cex=4,
   col=colorVlite2);

# Making a color lighter can make it easier to add labels
# The setTextContrastColor() function also helps.
graphics::text(x=c(1,2,1,2), y=c(1,2,2,1), 1:4,
   col=setTextContrastColor(colorVlite2));

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
