% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdenticon.R
\name{jdenticon}
\alias{jdenticon}
\title{Create a Jdenticon.}
\usage{
jdenticon(
  value = NULL,
  filePath = tempdir(),
  fileName = glue::glue("jdenticon_{size}_{value}"),
  size = "100",
  config = NULL,
  type = "png",
  preview = interactive() && Sys.getenv("RSTUDIO") == "1",
  return_list = FALSE
)
}
\arguments{
\item{value}{\code{character} Value to be converted to hexadecimal hash to render Jdenticon. Cannot contain characters that are reserved for filepaths:}

\item{filePath}{\code{character} File path to save Jdenticon .png to. If \code{NULL}, defaults to current working directory.}

\item{fileName}{\code{character} File name to save Jdenticon .png as. If \code{NULL}, defaults to \verb{temp_jdenticon_\{value\}}.}

\item{size}{\code{numeric} Size of Jdenticon. Default == 100.}

\item{config}{list of jdenticon configuration options (see \href{https://jdenticon.com/js-api/M_jdenticon_toPng.html}{the jdenticon documentation})}

\item{type}{Image type (default 'png', or 'svg')}

\item{preview}{\code{boolean} Preview Jdenticon in viewer pane?}

\item{return_list}{\code{boolean} Return full list object with all settings?}
}
\value{
Path to Jdenticon icon file, or (if \code{return_list} is true) a list with all parameters (including path).
}
\description{
Create a Jdenticon.
}
\examples{
\dontrun{
jdenticon(value = 'mango')
}

}
